# Modules
INSERT INTO `modules` SET `name`='Accessibility Controls', `file_name`='accessibility', `class_name`='AccessibilityModule';
INSERT INTO `modules` SET `name`='Business Directory Coupons', `file_name`='directory_coupons', `class_name`='DirectoryCouponsModule';
INSERT INTO `modules` SET `name`='Business Directory Featured Businesses', `file_name`='directory_featured', `class_name`='DirectoryFeaturedModule';
INSERT INTO `modules` SET `name`='Business Directory Google Map', `file_name`='directory_googlemap', `class_name`='DirectoryGoogleMap';
INSERT INTO `modules` SET `name`='Business Directory', `file_name`='directory', `class_name`='DirectoryModule';
INSERT INTO `modules` SET `name`='Contact Form', `file_name`='contact', `class_name`='ContactForm';
INSERT INTO `modules` SET `name`='Contact Information', `file_name`='contact_info', `class_name`='ContactInfoModule';
INSERT INTO `modules` SET `name`='Custom Content', `file_name`='html', `class_name`='CustomHTML';
INSERT INTO `modules` SET `name`='Event Calendar', `file_name`='calendar', `class_name`='CalendarModule';
INSERT INTO `modules` SET `name`='Events - Upcoming', `file_name`='events_upcoming', `class_name`='UpcomingEventsModule';
INSERT INTO `modules` SET `name`='Events Application Form', `file_name`='events_application', `class_name`='EventsApplicationModule';
INSERT INTO `modules` SET `name`='Events', `file_name`='events', `class_name`='EventsModule';
INSERT INTO `modules` SET `name`='Gallery - Galleria', `file_name`='galleria', `class_name`='Galleria';
INSERT INTO `modules` SET `name`='Gallery', `file_name`='gallery', `class_name`='Gallery';
INSERT INTO `modules` SET `name`='Google Map', `file_name`='googlemap', `class_name`='GoogleMap';
INSERT INTO `modules` SET `name`='Header 1', `file_name`='header1', `class_name`='Header1Module';
INSERT INTO `modules` SET `name`='Image Slideshow - bxSlider', `file_name`='slideshow_bxslider', `class_name`='bxSlider';
INSERT INTO `modules` SET `name`='Image Slideshow - Nivo Slider', `file_name`='slideshow_nivoslider', `class_name`='NivoSlider';
INSERT INTO `modules` SET `name`='Image Slideshow - Slippry', `file_name`='slideshow_slippry', `class_name`='Slippry';
INSERT INTO `modules` SET `name`='Logo', `file_name`='logo', `class_name`='LogoModule';
INSERT INTO `modules` SET `name`='Monthly Specials', `file_name`='monthly_specials', `class_name`='MonthlySpecials';
INSERT INTO `modules` SET `name`='Navigation Menu', `file_name`='menu', `class_name`='MenuModule';
INSERT INTO `modules` SET `name`='Online Booking', `file_name`='booking', `class_name`='BookingModule';
INSERT INTO `modules` SET `name`='Random Image', `file_name`='random_image', `class_name`='RandomImage';
INSERT INTO `modules` SET `name`='RSS Feed - YouTube', `file_name`='rss_youtube', `class_name`='RSSYouTubeModule';
INSERT INTO `modules` SET `name`='RSS Feed', `file_name`='rss', `class_name`='RSSFeedModule';
INSERT INTO `modules` SET `name`='Services', `file_name`='services', `class_name`='ServicesModule';
INSERT INTO `modules` SET `name`='Shop - Account', `file_name`='account', `class_name`='AccountModule';
INSERT INTO `modules` SET `name`='Shop - Breadcrumbs', `file_name`='shop_breadcrumb', `class_name`='ShopBreadcrumbModule';
INSERT INTO `modules` SET `name`='Shop - Cart', `file_name`='shop_cart', `class_name`='ShopCartModule';
INSERT INTO `modules` SET `name`='Shop - Category Menu', `file_name`='shop_menu', `class_name`='ShopCategoryMenu';
INSERT INTO `modules` SET `name`='Shop - Category', `file_name`='shop_category', `class_name`='ShopCategoryModule';
INSERT INTO `modules` SET `name`='Shop - Currency', `file_name`='shop_currency', `class_name`='ShopCurrencyModule';
INSERT INTO `modules` SET `name`='Shop - Search Filter', `file_name`='shop_filter', `class_name`='ShopFilterModule';
INSERT INTO `modules` SET `name`='Shop - Search', `file_name`='shop_search', `class_name`='ShopSearchModule';
INSERT INTO `modules` SET `name`='Shop - Shipping Estimate', `file_name`='shop_shipping', `class_name`='ShopShippingModule';
INSERT INTO `modules` SET `name`='Social Media Icons', `file_name`='social', `class_name`='SocialModule';
INSERT INTO `modules` SET `name`='Team', `file_name`='team', `class_name`='TeamModule';
INSERT INTO `modules` SET `name`='User Login', `file_name`='login', `class_name`='LoginModule';
INSERT INTO `modules` SET `name`='User Registration', `file_name`='registration', `class_name`='RegistrationModule';
INSERT INTO `modules` SET `name`='Video', `file_name`='video', `class_name`='HTML5Video';
INSERT INTO `modules` SET `name`='Announcement', `file_name`='announcement', `class_name`='AnnouncementModule';
INSERT INTO `modules` SET `name`="Facebook Page Feed", `file_name`="facebook_page", `class_name`="FacebookPageModule";
INSERT INTO `modules` SET `name`="Content List", `file_name`="content_list", `class_name`="ContentListModule";
INSERT INTO `modules` SET `name`="Content Slider", `file_name`="content_slider", `class_name`="ContentSliderModule";
INSERT INTO `modules` SET `name`="NV Menu", `file_name`="nvmenu", `class_name`="NerivonMenu";
INSERT INTO `modules` SET `name`="Documents", `file_name`="documents", `class_name`="DocumentsModule";
INSERT INTO `modules` SET `name`="Search", `file_name`="search", `class_name`="SearchModule";
INSERT INTO `modules` SET `name`="Hours of Operation", `file_name`="hours", `class_name`="HoursModule";
INSERT INTO `modules` SET `name`='Instagram Slider', `file_name`='instagram_slider', `class_name`='InstagramSlider';
INSERT INTO `modules` SET `name`='Google Calendar', `file_name`='gcal', `class_name`='GoogleCalendarModule';
# End of modules

# Create a site.
INSERT INTO `sites` SET `name`="{name}", `title`="{title}", `template_id`="{template_id}", `theme`="{theme}", `font`="{font}", `login_page_id`=null, `registration_page_id`=null, `ga_code`=null, `enable_retina`=1, `enable_html5`=0, `show_landing`=1, `facebook_sdk`=0, `common_less`=1, `combine_css`=1, `loading_overlay`=1, `fontawesome`=1, `mail_from`="{company}", `mail_replyto`="{email}", `mail_username`="noreply@{domain}", `mail_password`=NULL, `mail_host`="localhost", `mail_port`="587", `mail_tls`="tls";

# Add categories.
INSERT INTO `categories` SET `site_id`=1, `name`="News";
INSERT INTO `categories` SET `site_id`=1, `name`="Events";
INSERT INTO `categories` SET `site_id`=1, `name`="Testimonials";
INSERT INTO `categories` SET `site_id`=1, `name`="Portfolio";

# Add content types.
INSERT INTO `content_types` SET `content_type_id`=1, `content_type`='Blank page', `filename`='default', `sort`=1;
INSERT INTO `content_types` SET `content_type_id`=2, `content_type`='Content with image aligned left or right', `filename`='content_image', `sort`=2;
INSERT INTO `content_types` SET `content_type_id`=3, `content_type`='Two columns', `filename`='col2', `sort`=3;
INSERT INTO `content_types` SET `content_type_id`=4, `content_type`='Three columns', `filename`='col3', `sort`=4;
INSERT INTO `content_types` SET `content_type_id`=5, `content_type`='Four columns', `filename`='col4', `sort`=5;
INSERT INTO `content_types` SET `content_type_id`=6, `content_type`='Grid - 2 rows, 2 columns', `filename`='grid2x2', `sort`=6;
INSERT INTO `content_types` SET `content_type_id`=7, `content_type`='Grid - 2 rows, 3 columns', `filename`='grid2x3', `sort`=7;
INSERT INTO `content_types` SET `content_type_id`=8, `content_type`='Grid - 3 rows, 3 columns', `filename`='grid3x3', `sort`=8;
INSERT INTO `content_types` SET `content_type_id`=9, `content_type`='Testimonial', `filename`='testimonial', `sort`=9;
INSERT INTO `content_types` SET `content_type_id`=10, `content_type`='Testimonial Snippet', `filename`='testimonial_snippet', `sort`=10;
INSERT INTO `content_types` SET `content_type_id`=11, `content_type`='Portfolio Item', `filename`='portfolio', `sort`=11;
INSERT INTO `content_types` SET `content_type_id`=12, `content_type`="Content List (blog, news, etc)", `filename`="content_list", `page_info`=1, `sort`=13;
INSERT INTO `content_types` SET `content_type_id`=13, `content_type`="Documents List", `filename`="documents", `page_info`=1, `sort`=13;
INSERT INTO `content_types` SET `content_type_id`=14, `content_type`="Contact Page", `filename`="contact", `page_info`=1, `sort`=14;
INSERT INTO `content_types` SET `content_type_id`=15, `content_type`="Photo Gallery", `filename`="gallery", `page_info`=1, `sort`=15;
INSERT INTO `content_types` SET `content_type_id`=16, `content_type`="User Login / Registration Page", `filename`="login", `page_info`=1, `sort`=16;
INSERT INTO `content_types` SET `content_type_id`=17, `content_type`="Services Page", `filename`="services", `page_info`=1, `sort`=17;
INSERT INTO `content_types` SET `content_type_id`=18, `content_type`="Our Team", `filename`="team", `page_info`=1, `sort`=18;
INSERT INTO `content_types` SET `content_type_id`=19, `content_type`="Business Directory", `filename`="directory", `page_info`=1, `sort`=19;
INSERT INTO `content_types` SET `content_type_id`=20, `content_type`="Event Listings", `filename`="events", `page_info`=1, `sort`=20;
INSERT INTO `content_types` SET `content_type_id`=21, `content_type`="User Account Portal", `filename`="account", `page_info`=1, `sort`=21;
INSERT INTO `content_types` SET `content_type_id`=22, `content_type`="Event Calendar", `filename`="calendar", `page_info`=1, `sort`=22;
INSERT INTO `content_types` SET `content_type_id`=23, `content_type`="Online Booking", `filename`="booking", `page_info`=1, `sort`=23;
INSERT INTO `content_types` SET `content_type_id`=24, `content_type`="Search Results", `filename`="search", `page_info`=1, `sort`=24;

# Create a user.
INSERT INTO `users` SET `username`="{username}", `password`="{password}", `fname`="{fname}", `lname`="{lname}", `company`="{company}", `email`="{email}", `joined`=NOW(), `joined_site_id`=1, `last_login`=null, `shopper_group_id`=null, `active`=1;

# Create a domain.
INSERT INTO `domains` SET `site_id`=1, `domain`="{domain}";
UPDATE `sites` SET `domain_id`=1 WHERE `site_id`=1;

# Create a main menu and a secondary menu.
INSERT INTO `menus` SET `site_id`=1, `name`="Main Menu";
INSERT INTO `menus` SET `site_id`=1, `name`="Secondary Menu";

# Create main page and a menu link for it on both menus.
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=1, `created`=NOW(), `title`="Home", `title_heading_level`=0, `url`="index", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=0, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="content1", `value`="<h1>Welcome to {company}</h1><p>Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p><p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?</p>";
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Home", `page_id`=@page_id, `url`="", `target`="", `sort`=1, `published`=1;
INSERT INTO `menu_items` SET `menu_id`=2, `parent_id`=null, `title`="Home", `page_id`=@page_id, `url`="", `target`="", `sort`=1, `published`=1;
UPDATE `sites` SET `default_page_id`=@page_id WHERE `site_id`=1;

# General data
-- UPDATE `templates` SET `name`="NCMS Cake Builder" WHERE `directory`="default";
UPDATE `templates` SET `name`="NCMS Custom Template" WHERE `directory`="default_custom";
