# Create directory page and a menu link for it on the main menu.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="directory" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Directory", `title_heading_level`=1, `url`="directory", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=1, `allow_url_query`=1, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Directory", `page_id`=@page_id, `url`="", `target`="", `sort`=6, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the directory.
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="page_id", `value`=@page_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="google_api_key", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title", `value`="Business Directory";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="display", `value`="normal";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="extra_fields", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="allow_export", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_width_category", `value`=400;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_height_category", `value`=300;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_width_vcard", `value`=400;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_height_vcard", `value`=300;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_width_listing", `value`=400;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="max_height_listing", `value`=300;

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
