# Create documents page.
SELECT `content_type_id` FROM `content_types` WHERE `filename`="documents" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=null, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Documents", `title_heading_level`=1, `url`="docs", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=1, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `menu_items` SET `menu_id`=1, `parent_id`=null, `title`="Documents", `page_id`=@page_id, `url`="", `target`="", `sort`=3, `published`=1;
SELECT MAX(menu_item_id) FROM `menu_items` INTO @menu_item_id;

# Create a default configuration for the documents results module.
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="title_heading_level", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="module_class", `value`="";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="heading_level", `value`="h3";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="category_id", `value`=NULL;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_title", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_category", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_icons", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_text", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="character_limit", `value`=250;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="search_legend", `value`="Search Documents";
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_categories", `value`=1;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="show_previews", `value`=1;

# ACL
INSERT INTO `acl` SET `acl_role_id`=1, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `page_id`=@page_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `page_id`=@page_id, `read`=1, `write`=1;
INSERT INTO `acl` SET `acl_role_id`=1, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=2, `menu_item_id`=@menu_item_id, `read`=1, `write`=0;
INSERT INTO `acl` SET `acl_role_id`=3, `menu_item_id`=@menu_item_id, `read`=1, `write`=1;
