INSERT INTO `shop_category_layout` SET `category_layout_id`=1, `layout_name`="Default Category", `view_filename`="category_default", `sort_by`="product_name ASC", `show_subcategories`=1, `show_products`=1, `show_category_image`=1, `category_image_width`=250, `category_image_height`=250, `product_image_width`=250, `product_image_height`=250;
INSERT INTO `shop_product_layout` SET `product_layout_id`=1, `layout_name`="Default Layout", `view_filename`="product_default", `show_price`=1, `allow_purchase`=1, `product_image_width`=400, `product_image_height`=300, `extra_image_width`=250, `extra_image_height`=250;

INSERT INTO `shop_currency` SET `currency_id`=1, `currency_name`='Canadian Dollars', `currency_code`='CAD', `exchange_rate`=1.000000000000000;
INSERT INTO `shop_currency` SET `currency_id`=2, `currency_name`='US Dollars', `currency_code`='USD', `exchange_rate`=0.918726681568410;

INSERT INTO `shop_order_status` SET `order_status_id`=1, `order_status_name`='Processing';
INSERT INTO `shop_order_status` SET `order_status_id`=2, `order_status_name`='Shipped';
INSERT INTO `shop_order_status` SET `order_status_id`=3, `order_status_name`='Complete';
INSERT INTO `shop_order_status` SET `order_status_id`=4, `order_status_name`='Rejected';

INSERT INTO `shop_payment_gateways` SET `payment_gateway_id`=1, `site_id`=1, `enabled`=1, `gateway_name`='Interac e-Transfer', `filename`='interac_etransfer', `sort`=1, `configuration`='';
INSERT INTO `shop_payment_gateways` SET `payment_gateway_id`=2, `site_id`=1, `enabled`=0, `gateway_name`='Credit Card - Processed by <a href="https://stripe.com" target="_blank">Stripe</a>', `filename`='stripe', `sort`=2, `configuration`="private_key=\npublic_key=\n\n";
INSERT INTO `shop_payment_gateways` SET `payment_gateway_id`=3, `site_id`=1, `enabled`=0, `gateway_name`='PayPal', `filename`='paypal_hosted', `sort`=3, `configuration`="business=\nnotify_url=\nreturn=\ncancel_return=\nsandbox=0\n";
INSERT INTO `shop_payment_gateways` SET `payment_gateway_id`=4, `site_id`=1, `enabled`=0, `gateway_name`='Credit Card - Processed by <a href="https://www.elavon.com" target="_blank">Elavon</a>', `filename`='creditcard', `sort`=4, `configuration`="url=https://demo.myvirtualmerchant.com/VirtualMerchantDemo/process.do\nmerchant_id=000306\nuser_id=webpage\npin=0P25CN";
INSERT INTO `shop_payment_gateways` SET `payment_gateway_id`=5, `site_id`=1, `enabled`=0, `gateway_name`='Moneris Hosted Payment Page', `filename`='moneris_hosted', `sort`=5, `configuration`="url=https://esqa.moneris.com/HPPDP/index.php\nps_store_id=\nhpp_key=\n";

INSERT INTO `shop_shipping_gateways` SET `shipping_gateway_id`=1, `site_id`=1, `enabled`=1, `gateway_name`='Choose a Carrier', `filename`='shippo', `sort`=1, `configuration`='api_key=shippo_live_40cdfb32a669e1b462df412a59adfc0397c9c8dc\naddress=\ncity=\nprovince=ON\npostalcode=\ncountry=CA\ndefault_length=10\ndefault_width=10\ndefault_height=10\ndefault_weight=3\n';
INSERT INTO `shop_shipping_gateways` SET `shipping_gateway_id`=2, `site_id`=1, `enabled`=0, `gateway_name`='Flat Rate', `filename`='flatrate', `sort`=2, `configuration`="rate=20\n";
INSERT INTO `shop_shipping_gateways` SET `shipping_gateway_id`=3, `site_id`=1, `enabled`=1, `gateway_name`='Pickup In Store', `filename`='pickup', `sort`=3, `configuration`='';

INSERT INTO `shop_taxes` SET `tax_id`=1, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='AB';
INSERT INTO `shop_taxes` SET `tax_id`=2, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='BC';
INSERT INTO `shop_taxes` SET `tax_id`=3, `site_id`=1, `tax_name`='PST', `tax_percentage`=0.07000, `tax_country`='CA', `tax_province`='BC';
INSERT INTO `shop_taxes` SET `tax_id`=4, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='MB';
INSERT INTO `shop_taxes` SET `tax_id`=5, `site_id`=1, `tax_name`='PST', `tax_percentage`=0.08000, `tax_country`='CA', `tax_province`='MB';
INSERT INTO `shop_taxes` SET `tax_id`=6, `site_id`=1, `tax_name`='HST', `tax_percentage`=0.13000, `tax_country`='CA', `tax_province`='NB';
INSERT INTO `shop_taxes` SET `tax_id`=7, `site_id`=1, `tax_name`='HST', `tax_percentage`=0.13000, `tax_country`='CA', `tax_province`='NL';
INSERT INTO `shop_taxes` SET `tax_id`=8, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='NT';
INSERT INTO `shop_taxes` SET `tax_id`=9, `site_id`=1, `tax_name`='HST', `tax_percentage`=0.15000, `tax_country`='CA', `tax_province`='NS';
INSERT INTO `shop_taxes` SET `tax_id`=10, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='NU';
INSERT INTO `shop_taxes` SET `tax_id`=11, `site_id`=1, `tax_name`='HST', `tax_percentage`=0.13000, `tax_country`='CA', `tax_province`='ON';
INSERT INTO `shop_taxes` SET `tax_id`=12, `site_id`=1, `tax_name`='HST', `tax_percentage`=0.14000, `tax_country`='CA', `tax_province`='PE';
INSERT INTO `shop_taxes` SET `tax_id`=13, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='QC';
INSERT INTO `shop_taxes` SET `tax_id`=14, `site_id`=1, `tax_name`='QST', `tax_percentage`=0.09975, `tax_country`='CA', `tax_province`='QC';
INSERT INTO `shop_taxes` SET `tax_id`=15, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='SK';
INSERT INTO `shop_taxes` SET `tax_id`=16, `site_id`=1, `tax_name`='PST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='SK';
INSERT INTO `shop_taxes` SET `tax_id`=17, `site_id`=1, `tax_name`='GST', `tax_percentage`=0.05000, `tax_country`='CA', `tax_province`='YT';

INSERT INTO `shop_config` SET `config_id`=1, `site_id`=1, `config_label`='Shop Page', `config_key`='page_id', `config_value`=(SELECT IF(page_id IS NULL, "", page_id) FROM pages WHERE `title`="Shop"), `input_type`='pagelist', `sort`=1;
INSERT INTO `shop_config` SET `config_id`=2, `site_id`=1, `config_label`='Index View Filename', `config_key`='index_view_filename', `config_value`='default', `input_type`='text', `sort`=2;
INSERT INTO `shop_config` SET `config_id`=3, `site_id`=1, `config_label`='Shop Search Category Layout', `config_key`='search_category_layout_id', `config_value`='1', `input_type`='categorylayoutlist', `sort`=3;
INSERT INTO `shop_config` SET `config_id`=4, `site_id`=1, `config_label`='Products Per Page', `config_key`='products_per_page', `config_value`='12', `input_type`='number', `sort`=4;
INSERT INTO `shop_config` SET `config_id`=5, `site_id`=1, `config_label`='Product Link Text', `config_key`='product_link_text', `config_value`='More Info <i class=\'fas fa-info-circle\'></i>', `input_type`='text', `sort`=5;
INSERT INTO `shop_config` SET `config_id`=6, `site_id`=1, `config_label`='Successful Transaction Link', `config_key`='successful_transaction_link', `config_value`='/shop', `input_type`='text', `sort`=6;
INSERT INTO `shop_config` SET `config_id`=7, `site_id`=1, `config_label`='Send Order Notifications To', `config_key`='order_notifications', `config_value`='', `input_type`='text', `sort`=7;
INSERT INTO `shop_config` SET `config_id`=8, `site_id`=1, `config_label`='Category Link Text', `config_key`='category_link_text', `config_value`='View Category <i class=\'fas fa-arrow-right\'></i>', `input_type`='text', `sort`=8;
INSERT INTO `shop_config` SET `config_id`=9, `site_id`=1, `config_label`='Search View Filename', `config_key`='search_view_filename', `config_value`='search_default', `input_type`='text', `sort`=9;
INSERT INTO `shop_config` SET `config_id`=10, `site_id`=1, `config_label`='Default Category Layout', `config_key`='category_layout_id', `config_value`='1', `input_type`='text', `sort`=10;
INSERT INTO `shop_config` SET `config_id`=11, `site_id`=1, `config_label`='Checkout View Filename', `config_key`='checkout_view_filename', `config_value`='default', `input_type`='text', `sort`=11;
INSERT INTO `shop_shopper_groups` SET `site_id`=1, `group_name`='Default';
UPDATE `users` SET `shopper_group_id`=1;
