/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;


# Dump of table 404log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `404log`;

CREATE TABLE `404log` (
  `404log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(255) NOT NULL DEFAULT '',
  `count` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`404log_id`),
  UNIQUE KEY `url` (`url`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table acl
# ------------------------------------------------------------

DROP TABLE IF EXISTS `acl`;

CREATE TABLE `acl` (
  `acl_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `acl_role_id` int(11) unsigned NOT NULL,
  `page_id` int(11) unsigned DEFAULT NULL,
  `category_id` int(11) unsigned DEFAULT NULL,
  `document_id` int(11) unsigned DEFAULT NULL,
  `module_instance_id` int(11) unsigned DEFAULT NULL,
  `menu_item_id` int(11) unsigned DEFAULT NULL,
  `read` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `write` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`acl_id`),
  KEY `role_id` (`acl_role_id`),
  KEY `page_id` (`page_id`),
  KEY `category_id` (`category_id`),
  KEY `document_id` (`document_id`),
  KEY `module_instance_id` (`module_instance_id`),
  KEY `menu_item_id` (`menu_item_id`),
  CONSTRAINT `acl_ibfk_1` FOREIGN KEY (`acl_role_id`) REFERENCES `acl_role` (`acl_role_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `acl_ibfk_2` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `acl_ibfk_3` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `acl_ibfk_4` FOREIGN KEY (`document_id`) REFERENCES `document` (`document_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `acl_ibfk_5` FOREIGN KEY (`module_instance_id`) REFERENCES `module_instances` (`module_instance_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `acl_ibfk_6` FOREIGN KEY (`menu_item_id`) REFERENCES `menu_items` (`menu_item_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table acl_action
# ------------------------------------------------------------

DROP TABLE IF EXISTS `acl_action`;

CREATE TABLE `acl_action` (
  `acl_action_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `action` varchar(255) NOT NULL,
  `constant` varchar(255) NOT NULL,
  PRIMARY KEY (`acl_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table acl_role
# ------------------------------------------------------------

DROP TABLE IF EXISTS `acl_role`;

CREATE TABLE `acl_role` (
  `acl_role_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `role` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT '',
  PRIMARY KEY (`acl_role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table acl_role_action
# ------------------------------------------------------------

DROP TABLE IF EXISTS `acl_role_action`;

CREATE TABLE `acl_role_action` (
  `acl_role_action_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `acl_role_id` int(11) unsigned NOT NULL,
  `acl_action_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`acl_role_action_id`),
  KEY `fk_role_action_role_id` (`acl_role_id`),
  KEY `fk_role_action_action_id` (`acl_action_id`),
  CONSTRAINT `fk_role_action_action_id` FOREIGN KEY (`acl_action_id`) REFERENCES `acl_action` (`acl_action_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_role_action_role_id` FOREIGN KEY (`acl_role_id`) REFERENCES `acl_role` (`acl_role_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table acl_user_role
# ------------------------------------------------------------

DROP TABLE IF EXISTS `acl_user_role`;

CREATE TABLE `acl_user_role` (
  `acl_user_role_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(11) unsigned NOT NULL,
  `acl_role_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`acl_user_role_id`),
  KEY `fk_user_role_user_id` (`user_id`),
  KEY `fk_user_role_role_id` (`acl_role_id`),
  CONSTRAINT `fk_user_role_role_id` FOREIGN KEY (`acl_role_id`) REFERENCES `acl_role` (`acl_role_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_user_role_user_id` FOREIGN KEY (`user_id`) REFERENCES `users` (`user_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table booking_appointments
# ------------------------------------------------------------

DROP TABLE IF EXISTS `booking_appointments`;

CREATE TABLE `booking_appointments` (
  `booking_appointment_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(255) NOT NULL,
  `appointment_date` datetime NOT NULL,
  `appointment_for` varchar(255) NOT NULL,
  `appointment_with` varchar(255) NOT NULL,
  `notes` text NOT NULL,
  PRIMARY KEY (`booking_appointment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table categories
# ------------------------------------------------------------

DROP TABLE IF EXISTS `categories`;

CREATE TABLE `categories` (
  `category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`category_id`),
  KEY `fk_categories_site_id` (`site_id`),
  CONSTRAINT `fk_categories_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table contact_responses
# ------------------------------------------------------------

DROP TABLE IF EXISTS `contact_responses`;

CREATE TABLE `contact_responses` (
  `response_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `message` text,
  `extra_fields` text,
  PRIMARY KEY (`response_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table content_types
# ------------------------------------------------------------

DROP TABLE IF EXISTS `content_types`;

CREATE TABLE `content_types` (
  `content_type_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `page_info` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `sort` int(11) unsigned NOT NULL,
  PRIMARY KEY (`content_type_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table content_values
# ------------------------------------------------------------

DROP TABLE IF EXISTS `content_values`;

CREATE TABLE `content_values` (
  `content_value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) unsigned NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`content_value_id`),
  KEY `module_key` (`key`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `content_values_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table crawler_issues
# ------------------------------------------------------------

DROP TABLE IF EXISTS `crawler_issues`;

CREATE TABLE `crawler_issues` (
  `issue_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `crawltime` datetime NOT NULL,
  `page_url` varchar(255) NOT NULL DEFAULT '',
  `severity` int(11) unsigned NOT NULL DEFAULT '1',
  `notes` text NOT NULL,
  PRIMARY KEY (`issue_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table directory_categories
# ------------------------------------------------------------

DROP TABLE IF EXISTS `directory_categories`;

CREATE TABLE `directory_categories` (
  `category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `category_name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `description` text NOT NULL,
  `photo` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`category_id`),
  KEY `fk_directory_categories_parent_id` (`parent_id`),
  KEY `fk_directory_categories_site_id` (`site_id`),
  KEY `url` (`url`),
  CONSTRAINT `fk_directory_categories_parent_id` FOREIGN KEY (`parent_id`) REFERENCES `directory_categories` (`category_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_directory_categories_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table directory_companies
# ------------------------------------------------------------

DROP TABLE IF EXISTS `directory_companies`;

CREATE TABLE `directory_companies` (
  `company_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `company` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `contact` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `city` varchar(255) NOT NULL,
  `province` varchar(255) NOT NULL,
  `postalcode` char(6) NOT NULL,
  `phone` varchar(25) NOT NULL,
  `fax` varchar(25) NOT NULL,
  `email` varchar(255) NOT NULL,
  `website` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `internal_notes` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT '',
  `photo` varchar(255) DEFAULT '',
  `added` datetime NOT NULL,
  `latitude` varchar(50) DEFAULT NULL,
  `longitude` varchar(50) DEFAULT NULL,
  `sv_heading` varchar(50) DEFAULT NULL,
  `sv_pitch` varchar(50) DEFAULT NULL,
  `sv_zoom` varchar(50) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`company_id`),
  KEY `fk_directory_companies_site_id` (`site_id`),
  KEY `url` (`url`),
  CONSTRAINT `fk_directory_companies_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table directory_companies_categories
# ------------------------------------------------------------

DROP TABLE IF EXISTS `directory_companies_categories`;

CREATE TABLE `directory_companies_categories` (
  `directory_company_category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `company_id` int(11) unsigned NOT NULL,
  `category_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`directory_company_category_id`),
  KEY `fk_directory_companies_categories_company_id` (`company_id`),
  KEY `fk_directory_companies_categories_category_id` (`category_id`),
  CONSTRAINT `fk_directory_companies_categories_category_id` FOREIGN KEY (`category_id`) REFERENCES `directory_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_directory_companies_categories_company_id` FOREIGN KEY (`company_id`) REFERENCES `directory_companies` (`company_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table directory_coupons
# ------------------------------------------------------------

DROP TABLE IF EXISTS `directory_coupons`;

CREATE TABLE `directory_coupons` (
  `coupon_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `company_id` int(11) unsigned NOT NULL,
  `valid_from` date DEFAULT NULL,
  `valid_to` date DEFAULT NULL,
  `coupon` text NOT NULL,
  PRIMARY KEY (`coupon_id`),
  KEY `fk_directory_coupons_company_id` (`company_id`),
  KEY `fk_directory_coupons_site_id` (`site_id`),
  CONSTRAINT `fk_directory_coupons_company_id` FOREIGN KEY (`company_id`) REFERENCES `directory_companies` (`company_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_directory_coupons_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table document
# ------------------------------------------------------------

DROP TABLE IF EXISTS `document`;

CREATE TABLE `document` (
  `document_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `category_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `filename` varchar(255) NOT NULL,
  `content_disposition` enum('attachment','inline') NOT NULL DEFAULT 'inline',
  `created` datetime NOT NULL,
  `created_user_id` int(11) unsigned DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_user_id` int(11) unsigned DEFAULT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=public, 2=login, 3=admin',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`document_id`),
  KEY `created_user_id` (`created_user_id`),
  KEY `modified_user_id` (`modified_user_id`),
  KEY `site_id` (`site_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `document_ibfk_1` FOREIGN KEY (`created_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_2` FOREIGN KEY (`modified_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_3` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_4` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table document_log
# ------------------------------------------------------------

DROP TABLE IF EXISTS `document_log`;

CREATE TABLE `document_log` (
  `document_log_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(11) unsigned DEFAULT NULL,
  `action_date` datetime NOT NULL,
  `action` text NOT NULL,
  PRIMARY KEY (`document_log_id`),
  KEY `document_id` (`document_id`),
  CONSTRAINT `document_log_ibfk_1` FOREIGN KEY (`document_id`) REFERENCES `document` (`document_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table domains
# ------------------------------------------------------------

DROP TABLE IF EXISTS `domains`;

CREATE TABLE `domains` (
  `domain_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `domain` varchar(255) NOT NULL,
  `site_id` int(11) unsigned NOT NULL,
  `redirect_url` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`domain_id`),
  KEY `fk_domains_site_id` (`site_id`),
  CONSTRAINT `fk_domains_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table events
# ------------------------------------------------------------

DROP TABLE IF EXISTS `events`;

CREATE TABLE `events` (
  `event_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `parent_id` int(11) unsigned DEFAULT NULL,
  `is_parent` tinyint(1) NOT NULL DEFAULT '0',
  `event_date` date DEFAULT NULL,
  `time_start` time DEFAULT NULL,
  `time_end` time DEFAULT NULL,
  `all_day` tinyint(1) NOT NULL DEFAULT '0',
  `headline` varchar(255) NOT NULL DEFAULT '',
  `url` varchar(255) NOT NULL DEFAULT '',
  `banner_image` varchar(255) DEFAULT NULL,
  `preview` text,
  `description` text,
  `galleries` text,
  PRIMARY KEY (`event_id`),
  KEY `fk_events_parent_id` (`parent_id`),
  KEY `fk_events_site_id` (`site_id`),
  KEY `url` (`url`),
  CONSTRAINT `fk_events_parent_id` FOREIGN KEY (`parent_id`) REFERENCES `events` (`event_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_events_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table events_forms
# ------------------------------------------------------------

DROP TABLE IF EXISTS `events_forms`;

CREATE TABLE `events_forms` (
  `form_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `event_id` int(11) unsigned NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `registration_start` date NOT NULL,
  `registration_end` date NOT NULL,
  `fee` decimal(10,2) NOT NULL DEFAULT '0.00',
  `terms` text,
  PRIMARY KEY (`form_id`),
  KEY `fk_events_forms_event_id` (`event_id`),
  CONSTRAINT `fk_events_forms_event_id` FOREIGN KEY (`event_id`) REFERENCES `events` (`event_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table menu_items
# ------------------------------------------------------------

DROP TABLE IF EXISTS `menu_items`;

CREATE TABLE `menu_items` (
  `menu_item_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` int(11) unsigned NOT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `title_tag` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(25) DEFAULT NULL,
  `page_id` int(11) unsigned DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `target` enum('','_blank') NOT NULL,
  `sort` int(11) unsigned NOT NULL,
  `published` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`menu_item_id`),
  KEY `fk_menu_items_menu_id` (`menu_id`),
  KEY `fk_menu_items_parent_id` (`parent_id`),
  KEY `fk_menu_items_page_id` (`page_id`),
  CONSTRAINT `fk_menu_items_menu_id` FOREIGN KEY (`menu_id`) REFERENCES `menus` (`menu_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_menu_items_page_id` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_menu_items_parent_id` FOREIGN KEY (`parent_id`) REFERENCES `menu_items` (`menu_item_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table menus
# ------------------------------------------------------------

DROP TABLE IF EXISTS `menus`;

CREATE TABLE `menus` (
  `menu_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`menu_id`),
  KEY `fk_menus_site_id` (`site_id`),
  CONSTRAINT `fk_menus_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table metadata_pages
# ------------------------------------------------------------

DROP TABLE IF EXISTS `metadata_pages`;

CREATE TABLE `metadata_pages` (
  `metadata_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `page_id` int(11) unsigned DEFAULT NULL,
  `url` varchar(255) NOT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`metadata_id`),
  UNIQUE KEY `url` (`url`),
  KEY `fk_metadata_pages_page_id` (`page_id`),
  KEY `fk_metadata_pages_site_id` (`site_id`),
  CONSTRAINT `fk_metadata_pages_page_id` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_metadata_pages_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table module_instances
# ------------------------------------------------------------

DROP TABLE IF EXISTS `module_instances`;

CREATE TABLE `module_instances` (
  `module_instance_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module_id` int(11) unsigned NOT NULL,
  `site_id` int(11) unsigned NOT NULL,
  `tag` varchar(255) NOT NULL,
  `position` varchar(255) DEFAULT NULL,
  `always_on` tinyint(1) NOT NULL DEFAULT '0',
  `sort` int(3) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_instance_id`),
  KEY `fk_module_instances_site_id` (`site_id`),
  KEY `fk_module_instances_module_id` (`module_id`),
  CONSTRAINT `fk_module_instances_module_id` FOREIGN KEY (`module_id`) REFERENCES `modules` (`module_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_module_instances_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table module_settings
# ------------------------------------------------------------

DROP TABLE IF EXISTS `module_settings`;

CREATE TABLE `module_settings` (
  `module_setting_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module_instance_id` int(11) unsigned NOT NULL,
  `key` varchar(255) NOT NULL,
  `value` text,
  PRIMARY KEY (`module_setting_id`),
  KEY `fk_module_settings_instance_id` (`module_instance_id`),
  KEY `module_key` (`key`),
  CONSTRAINT `fk_module_settings_instance_id` FOREIGN KEY (`module_instance_id`) REFERENCES `module_instances` (`module_instance_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table modules
# ------------------------------------------------------------

DROP TABLE IF EXISTS `modules`;

CREATE TABLE `modules` (
  `module_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `file_name` varchar(255) NOT NULL,
  `class_name` varchar(255) NOT NULL,
  PRIMARY KEY (`module_id`),
  UNIQUE KEY `file_name` (`file_name`),
  UNIQUE KEY `class_name` (`class_name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table modules_pages
# ------------------------------------------------------------

DROP TABLE IF EXISTS `modules_pages`;

CREATE TABLE `modules_pages` (
  `module_page_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `module_instance_id` int(11) unsigned NOT NULL,
  `page_id` int(11) unsigned NOT NULL,
  `sort` int(3) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`module_page_id`),
  KEY `fk_modules_pages_module_instance_id` (`module_instance_id`),
  KEY `fk_modules_pages_page_id` (`page_id`),
  CONSTRAINT `fk_modules_pages_module_instance_id` FOREIGN KEY (`module_instance_id`) REFERENCES `module_instances` (`module_instance_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_modules_pages_page_id` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table pages
# ------------------------------------------------------------

DROP TABLE IF EXISTS `pages`;

CREATE TABLE `pages` (
  `page_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `category_id` int(11) unsigned DEFAULT NULL,
  `content_type_id` int(11) unsigned NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `modified` datetime DEFAULT NULL,
  `start_publishing` datetime DEFAULT NULL,
  `stop_publishing` datetime DEFAULT NULL,
  `title` varchar(255) NOT NULL,
  `title_heading_level` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `url` varchar(255) NOT NULL DEFAULT '',
  `url_override` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `content` text,
  `social` tinyint(1) NOT NULL DEFAULT '0',
  `rss` tinyint(1) NOT NULL DEFAULT '0',
  `searchable` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `allow_url_segments` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `allow_url_query` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `og_type` VARCHAR(255) NULL,
  `og_image` VARCHAR(255) NULL,
  `sitemap_priority` VARCHAR(8) NULL,
  `sitemap_changefreq` VARCHAR(16) NULL,
  PRIMARY KEY (`page_id`),
  UNIQUE KEY `site_id_url` (`site_id`,`url`),
  KEY `fk_pages_site_id` (`site_id`),
  KEY `fk_pages_category_id` (`category_id`),
  KEY `content_types_ibfk_1` (`content_type_id`),
  CONSTRAINT `content_types_ibfk_1` FOREIGN KEY (`content_type_id`) REFERENCES `content_types` (`content_type_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_pages_category_id` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_pages_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table redirects
# ------------------------------------------------------------

DROP TABLE IF EXISTS `redirects`;

CREATE TABLE `redirects` (
  `redirect_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `old_url` varchar(255) NOT NULL DEFAULT '',
  `new_url` varchar(255) DEFAULT NULL,
  `page_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`redirect_id`),
  KEY `page_id` (`page_id`),
  KEY `site_id` (`site_id`),
  KEY `old_url` (`old_url`),
  CONSTRAINT `redirects_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `redirects_ibfk_2` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_cart
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_cart`;

CREATE TABLE `shop_cart` (
  `cart_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `session_id` varchar(255) DEFAULT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `product_variant_id` int(11) unsigned DEFAULT NULL,
  `quantity` int(11) unsigned NOT NULL DEFAULT '1',
  `product_options` text,
  PRIMARY KEY (`cart_id`),
  KEY `fk_shop_cart_product_id` (`product_id`),
  KEY `shop_cart_product_variant_id` (`product_variant_id`),
  CONSTRAINT `fk_shop_cart_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_cart_product_variant_id` FOREIGN KEY (`product_variant_id`) REFERENCES `shop_product_variant` (`product_variant_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_categories
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_categories`;

CREATE TABLE `shop_categories` (
  `category_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `parent_category_id` int(11) unsigned DEFAULT NULL,
  `datasource_category_id` varchar(255) DEFAULT NULL,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `category_layout_id` int(11) unsigned DEFAULT '1',
  `default_product_layout_id` int(11) unsigned NOT NULL DEFAULT '1',
  `category_name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `page_title` varchar(255) DEFAULT NULL,
  `meta_description` varchar(255) DEFAULT NULL,
  `category_description` text,
  `category_image_id` int(11) unsigned DEFAULT NULL,
  `not_authorized_page_id` int(11) unsigned DEFAULT NULL,
  `sort` int(11) unsigned NOT NULL DEFAULT '1',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`category_id`),
  KEY `fk_shop_categories_category_layout_id` (`category_layout_id`),
  KEY `datasource_category_id` (`datasource_category_id`),
  KEY `published` (`published`),
  KEY `fk_shop_categories_parent_category_id` (`parent_category_id`),
  KEY `fk_shop_categories_site_id` (`site_id`),
  KEY `fk_shop_categories_default_product_layout_id` (`default_product_layout_id`),
  KEY `fk_shop_categories_category_image_id` (`category_image_id`),
  KEY `fk_shop_categories_not_authorized_page_id` (`not_authorized_page_id`),
  KEY `url` (`url`),
  CONSTRAINT `fk_shop_categories_category_image_id` FOREIGN KEY (`category_image_id`) REFERENCES `shop_images` (`image_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_category_layout_id` FOREIGN KEY (`category_layout_id`) REFERENCES `shop_category_layout` (`category_layout_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_default_product_layout_id` FOREIGN KEY (`default_product_layout_id`) REFERENCES `shop_product_layout` (`product_layout_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_not_authorized_page_id` FOREIGN KEY (`not_authorized_page_id`) REFERENCES `pages` (`page_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_parent_category_id` FOREIGN KEY (`parent_category_id`) REFERENCES `shop_categories` (`category_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_categories_products
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_categories_products`;

CREATE TABLE `shop_categories_products` (
  `shop_category_product_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`shop_category_product_id`),
  UNIQUE KEY `product_id` (`product_id`,`category_id`),
  KEY `fk_shop_categories_products_category_id` (`category_id`),
  KEY `fk_shop_categories_products_product_id` (`product_id`),
  CONSTRAINT `fk_shop_categories_products_category_id` FOREIGN KEY (`category_id`) REFERENCES `shop_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_products_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_categories_shopper_groups
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_categories_shopper_groups`;

CREATE TABLE `shop_categories_shopper_groups` (
  `shop_category_shopper_group_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `category_id` int(11) unsigned NOT NULL,
  `shopper_group_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`shop_category_shopper_group_id`),
  UNIQUE KEY `fk_shop_categories_shopper_groups_category_id` (`category_id`,`shopper_group_id`),
  KEY `fk_shop_categories_shopper_groups_shopper_group_id` (`shopper_group_id`),
  CONSTRAINT `fk_shop_categories_shopper_groups_category_id` FOREIGN KEY (`category_id`) REFERENCES `shop_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_categories_shopper_groups_shopper_group_id` FOREIGN KEY (`shopper_group_id`) REFERENCES `shop_shopper_groups` (`shopper_group_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_category_layout
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_category_layout`;

CREATE TABLE `shop_category_layout` (
  `category_layout_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `layout_name` varchar(255) NOT NULL,
  `view_filename` varchar(255) NOT NULL,
  `sort_by` varchar(255) NOT NULL DEFAULT 'product_name ASC',
  `show_subcategories` tinyint(4) NOT NULL DEFAULT '1',
  `show_products` tinyint(1) NOT NULL DEFAULT '1',
  `show_category_image` tinyint(1) NOT NULL DEFAULT '1',
  `category_image_width` int(11) unsigned NOT NULL DEFAULT '250',
  `category_image_height` int(11) unsigned NOT NULL DEFAULT '250',
  `product_image_width` int(11) unsigned NOT NULL DEFAULT '250',
  `product_image_height` int(11) unsigned NOT NULL DEFAULT '250',
  PRIMARY KEY (`category_layout_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_config
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_config`;

CREATE TABLE `shop_config` (
  `config_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `config_label` varchar(255) NOT NULL,
  `config_key` varchar(255) NOT NULL,
  `config_value` varchar(255) DEFAULT NULL,
  `input_type` enum('text','textarea','tel','email','number','checkbox','pagelist','categorylayoutlist') NOT NULL DEFAULT 'text',
  `sort` int(11) unsigned NOT NULL,
  PRIMARY KEY (`config_id`),
  KEY `fk_shop_config_site_id` (`site_id`),
  CONSTRAINT `fk_shop_config_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_currency
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_currency`;

CREATE TABLE `shop_currency` (
  `currency_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `currency_name` varchar(255) NOT NULL DEFAULT '',
  `currency_code` char(3) NOT NULL DEFAULT '',
  `exchange_rate` decimal(20,15) NOT NULL,
  PRIMARY KEY (`currency_id`),
  KEY `currency_code` (`currency_code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_datasources
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_datasources`;

CREATE TABLE `shop_datasources` (
  `datasource_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `datasource_name` varchar(255) NOT NULL,
  `controller_filename` varchar(255) NOT NULL,
  `default_layout_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`datasource_id`),
  KEY `fk_shop_datasources_site_id` (`site_id`),
  CONSTRAINT `fk_shop_datasources_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_images
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_images`;

CREATE TABLE `shop_images` (
  `image_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `product_id` int(11) unsigned DEFAULT NULL,
  `filename` varchar(255) NOT NULL DEFAULT '',
  `sort` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`image_id`),
  KEY `fk_shop_images_site_id` (`site_id`),
  KEY `fk_shop_images_product_id` (`product_id`),
  KEY `filename` (`filename`),
  CONSTRAINT `fk_shop_images_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_images_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_layout_specific_data
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_layout_specific_data`;

CREATE TABLE `shop_layout_specific_data` (
  `layout_specific_data_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `layout_id` int(11) unsigned NOT NULL,
  `data_name` varchar(255) NOT NULL,
  `data_group` varchar(255) NOT NULL,
  `key` varchar(255) NOT NULL,
  `datatype` enum('text','textarea','number','email','tel','file','url','video') NOT NULL DEFAULT 'text',
  `search_filter` tinyint(1) NOT NULL DEFAULT '0',
  `sort` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`layout_specific_data_id`),
  UNIQUE KEY `fk_shop_layout_specific_data_layout_id` (`layout_id`,`key`),
  KEY `data_name` (`data_name`),
  CONSTRAINT `fk_shop_layout_specific_data_layout_id` FOREIGN KEY (`layout_id`) REFERENCES `shop_product_layout` (`product_layout_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_layout_specific_data_values
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_layout_specific_data_values`;

CREATE TABLE `shop_layout_specific_data_values` (
  `layout_specific_data_value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `layout_specific_data_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  `data_value` text NOT NULL,
  PRIMARY KEY (`layout_specific_data_value_id`),
  UNIQUE KEY `fk_shop_layout_specific_data_values_layout_specific_data_id` (`layout_specific_data_id`,`product_id`),
  KEY `data_value` (`data_value`(255)),
  KEY `fk_shop_layout_specific_data_values_product_id` (`product_id`),
  CONSTRAINT `fk_shop_layout_specific_data_values_layout_specific_data_id` FOREIGN KEY (`layout_specific_data_id`) REFERENCES `shop_layout_specific_data` (`layout_specific_data_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_layout_specific_data_values_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_order_status
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_order_status`;

CREATE TABLE `shop_order_status` (
  `order_status_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `order_status_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`order_status_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_orders
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_orders`;

CREATE TABLE `shop_orders` (
  `order_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `order_date` datetime NOT NULL,
  `ship_date` datetime NOT NULL,
  `user_id` int(11) unsigned DEFAULT NULL,
  `order_status_id` int(11) unsigned NOT NULL,
  `payment_gateway_id` int(11) unsigned NOT NULL,
  `shipping_gateway_id` int(11) unsigned NOT NULL,
  `shipping_gateway_service` varchar(255) DEFAULT NULL,
  `currency_id` int(11) unsigned NOT NULL DEFAULT '1',
  `customer_name` varchar(255) NOT NULL DEFAULT '',
  `customer_phone` varchar(15) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `customer_address` varchar(255) NOT NULL DEFAULT '',
  `customer_city` varchar(255) NOT NULL DEFAULT '',
  `customer_province` char(2) NOT NULL DEFAULT '',
  `customer_postalcode` char(6) NOT NULL DEFAULT '',
  `customer_country` char(2) NOT NULL DEFAULT '',
  `products` text NOT NULL,
  `taxes` text NOT NULL,
  `shipping_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `tax_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_subtotal` decimal(10,2) NOT NULL DEFAULT '0.00',
  `order_total` decimal(10,2) NOT NULL DEFAULT '0.00',
  `txn_id` varchar(255) NOT NULL,
  `tracking_number1` varchar(255) NOT NULL DEFAULT '',
  `tracking_number2` varchar(255) NOT NULL DEFAULT '',
  `tracking_number3` varchar(255) NOT NULL DEFAULT '',
  `custom_fields` text,
  `paid` tinyint(1) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`order_id`),
  KEY `fk_shop_orders_payment_gateway_id` (`payment_gateway_id`),
  KEY `fk_shop_orders_shipping_gateway_id` (`shipping_gateway_id`),
  KEY `fk_shop_orders_order_status_id` (`order_status_id`),
  KEY `fk_shop_orders_currency_id` (`currency_id`),
  KEY `fk_shop_orders_site_id` (`site_id`),
  CONSTRAINT `fk_shop_orders_currency_id` FOREIGN KEY (`currency_id`) REFERENCES `shop_currency` (`currency_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_orders_order_status_id` FOREIGN KEY (`order_status_id`) REFERENCES `shop_order_status` (`order_status_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_orders_payment_gateway_id` FOREIGN KEY (`payment_gateway_id`) REFERENCES `shop_payment_gateways` (`payment_gateway_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_orders_shipping_gateway_id` FOREIGN KEY (`shipping_gateway_id`) REFERENCES `shop_shipping_gateways` (`shipping_gateway_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_orders_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_payment_gateways
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_payment_gateways`;

CREATE TABLE `shop_payment_gateways` (
  `payment_gateway_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `gateway_name` varchar(255) NOT NULL,
  `filename` varchar(255) NOT NULL DEFAULT '',
  `configuration` text,
  `sort` int(11) unsigned NOT NULL,
  PRIMARY KEY (`payment_gateway_id`),
  KEY `fk_shop_payment_gateways_site_id` (`site_id`),
  CONSTRAINT `fk_shop_payment_gateways_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_postalcodes
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_postalcodes`;

CREATE TABLE `shop_postalcodes` (
  `postalcode_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `city` varchar(255) NOT NULL DEFAULT '',
  `province` char(2) NOT NULL DEFAULT '',
  `postalcode` char(6) NOT NULL DEFAULT '',
  `country` char(2) NOT NULL DEFAULT '',
  `latitude` varchar(10) NOT NULL DEFAULT '',
  `longitude` varchar(10) NOT NULL DEFAULT '',
  PRIMARY KEY (`postalcode_id`),
  UNIQUE KEY `postalcode` (`postalcode`,`province`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_prices
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_prices`;

CREATE TABLE `shop_prices` (
  `price_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned NOT NULL,
  `product_variant_id` int(11) unsigned DEFAULT NULL,
  `shopper_group_id` int(11) unsigned NOT NULL,
  `price` decimal(10,2) unsigned DEFAULT NULL,
  PRIMARY KEY (`price_id`),
  UNIQUE KEY `product_id_variant_id_shopper_group_id` (`product_id`,`product_variant_id`,`shopper_group_id`),
  KEY `shop_prices_ibfk_2` (`product_variant_id`),
  KEY `shop_prices_ibfk_3` (`shopper_group_id`),
  CONSTRAINT `shop_prices_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_prices_ibfk_2` FOREIGN KEY (`product_variant_id`) REFERENCES `shop_product_variant` (`product_variant_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `shop_prices_ibfk_3` FOREIGN KEY (`shopper_group_id`) REFERENCES `shop_shopper_groups` (`shopper_group_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_product_layout
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_product_layout`;

CREATE TABLE `shop_product_layout` (
  `product_layout_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `layout_name` varchar(255) NOT NULL,
  `view_filename` varchar(255) NOT NULL,
  `show_price` tinyint(4) NOT NULL DEFAULT '1',
  `allow_purchase` tinyint(4) NOT NULL DEFAULT '1',
  `product_image_width` int(11) unsigned NOT NULL DEFAULT '400',
  `product_image_height` int(11) unsigned NOT NULL DEFAULT '400',
  `extra_image_width` int(11) unsigned NOT NULL DEFAULT '250',
  `extra_image_height` int(11) unsigned NOT NULL DEFAULT '250',
  PRIMARY KEY (`product_layout_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_product_options
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_product_options`;

CREATE TABLE `shop_product_options` (
  `product_option_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned DEFAULT NULL,
  `product_id` int(11) unsigned DEFAULT NULL,
  `category_id` int(11) unsigned DEFAULT NULL,
  `include_child_categories` tinyint(1) NOT NULL DEFAULT '1',
  `option_type` enum('text','textarea','number','checkbox','radio','select') NOT NULL DEFAULT 'text',
  `option_label` varchar(255) NOT NULL DEFAULT '',
  `option_description` text NOT NULL,
  `option_values` text NOT NULL,
  `option_required` tinyint(1) NOT NULL DEFAULT '0',
  `price_change` decimal(10,2) NOT NULL DEFAULT '0.00',
  PRIMARY KEY (`product_option_id`),
  KEY `fk_shop_product_options_product_id` (`product_id`),
  KEY `fk_shop_product_options_category_id` (`category_id`),
  KEY `fk_shop_product_options_site_id` (`site_id`),
  CONSTRAINT `fk_shop_product_options_category_id` FOREIGN KEY (`category_id`) REFERENCES `shop_categories` (`category_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_product_options_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_product_options_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_product_variant
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_product_variant`;

CREATE TABLE `shop_product_variant` (
  `product_variant_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned NOT NULL,
  `variant` varchar(255) NOT NULL DEFAULT '',
  `sort` int(11) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`product_variant_id`),
  KEY `product_id` (`product_id`),
  CONSTRAINT `shop_product_variant_ibfk_1` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_products
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_products`;

CREATE TABLE `shop_products` (
  `product_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `main_category_id` int(11) unsigned DEFAULT NULL,
  `product_layout_id` int(11) unsigned NOT NULL DEFAULT '1',
  `datasource_id` int(11) unsigned DEFAULT NULL,
  `datasource_product_id` varchar(255) DEFAULT NULL,
  `datasource_hash` varchar(255) DEFAULT NULL,
  `sku` varchar(255) DEFAULT NULL,
  `product_name` varchar(255) NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `page_title` varchar(255) DEFAULT NULL,
  `meta_description` varchar(255) DEFAULT '',
  `product_short_description` text,
  `product_description` text,
  `cost` decimal(10,2) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `price_lock` tinyint(1) NOT NULL DEFAULT '0',
  `deposit_price` decimal(10,2) NOT NULL DEFAULT '0.00',
  `call_for_price` tinyint(1) NOT NULL DEFAULT '0',
  `by_order_only` tinyint(1) NOT NULL DEFAULT '0',
  `out_of_stock` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_length` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_width` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_height` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_weight` decimal(10,2) NOT NULL DEFAULT '0.00',
  `shipping_tbd` tinyint(1) NOT NULL DEFAULT '0',
  `shipping_na` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `last_modified` datetime NOT NULL,
  `last_datasource_update` datetime NOT NULL,
  `product_image_id` int(11) unsigned DEFAULT NULL,
  `sort_priority` tinyint(1) NOT NULL DEFAULT '1',
  `corner_tag` tinyint(1) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`product_id`),
  KEY `fk_shop_products_product_layout_id` (`product_layout_id`),
  KEY `published` (`published`),
  KEY `fk_shop_products_site_id` (`site_id`),
  KEY `fk_shop_products_main_category_id` (`main_category_id`),
  KEY `fk_shop_products_datasource_id` (`datasource_id`),
  KEY `fk_shop_products_product_image_id` (`product_image_id`),
  KEY `url` (`url`),
  CONSTRAINT `fk_shop_products_datasource_id` FOREIGN KEY (`datasource_id`) REFERENCES `shop_datasources` (`datasource_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_products_main_category_id` FOREIGN KEY (`main_category_id`) REFERENCES `shop_categories` (`category_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_products_product_image_id` FOREIGN KEY (`product_image_id`) REFERENCES `shop_images` (`image_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_products_product_layout_id` FOREIGN KEY (`product_layout_id`) REFERENCES `shop_product_layout` (`product_layout_id`) ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_products_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_products_related
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_products_related`;

CREATE TABLE `shop_products_related` (
  `products_related_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `product_id` int(11) unsigned NOT NULL,
  `related_product_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`products_related_id`),
  UNIQUE KEY `fk_shop_products_related_related_product_id` (`product_id`,`products_related_id`),
  KEY `fk_shop_products_related_product_id` (`related_product_id`),
  CONSTRAINT `fk_shop_products_related_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_products_related_related_product_id` FOREIGN KEY (`related_product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_routes
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_routes`;

CREATE TABLE `shop_routes` (
  `route_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `category_path` varchar(255) NOT NULL DEFAULT '',
  `category_path_string` varchar(255) NOT NULL DEFAULT '',
  `category_id` int(11) unsigned DEFAULT NULL,
  `product_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`route_id`),
  UNIQUE KEY `url` (`url`),
  UNIQUE KEY `fk_shop_routes_category_id` (`category_id`),
  UNIQUE KEY `fk_shop_routes_product_id` (`product_id`),
  KEY `fk_shop_routes_site_id` (`site_id`),
  CONSTRAINT `fk_shop_routes_category_id` FOREIGN KEY (`category_id`) REFERENCES `shop_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_routes_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_routes_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_shipping_gateways
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_shipping_gateways`;

CREATE TABLE `shop_shipping_gateways` (
  `shipping_gateway_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `enabled` tinyint(4) NOT NULL DEFAULT '1',
  `gateway_name` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `configuration` text,
  `sort` int(11) unsigned NOT NULL,
  PRIMARY KEY (`shipping_gateway_id`),
  KEY `fk_shop_shipping_gateways_site_id` (`site_id`),
  CONSTRAINT `fk_shop_shipping_gateways_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_shopper_groups
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_shopper_groups`;

CREATE TABLE `shop_shopper_groups` (
  `shopper_group_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL DEFAULT '1',
  `group_name` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`shopper_group_id`),
  KEY `fk_shop_shopper_groups_site_id` (`site_id`),
  CONSTRAINT `fk_shop_shopper_groups_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_taxes
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_taxes`;

CREATE TABLE `shop_taxes` (
  `tax_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `tax_name` varchar(255) NOT NULL,
  `tax_percentage` decimal(6,5) NOT NULL,
  `tax_country` char(2) NOT NULL,
  `tax_province` char(2) NOT NULL,
  PRIMARY KEY (`tax_id`),
  KEY `tax_country` (`tax_country`),
  KEY `tax_province` (`tax_province`),
  KEY `fk_shop_taxes_site_id` (`site_id`),
  CONSTRAINT `fk_shop_taxes_site_id` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_vehicles
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_vehicles`;

CREATE TABLE `shop_vehicles` (
  `vehicle_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `datasource_vehicle_id` varchar(255) DEFAULT NULL,
  `year` float NOT NULL,
  `make` varchar(255) NOT NULL DEFAULT '',
  `model` varchar(255) NOT NULL DEFAULT '',
  `style` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`vehicle_id`),
  UNIQUE KEY `year` (`year`,`make`,`model`,`style`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table shop_vehicles_products
# ------------------------------------------------------------

DROP TABLE IF EXISTS `shop_vehicles_products`;

CREATE TABLE `shop_vehicles_products` (
  `shop_vehicle_product_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `vehicle_id` int(11) unsigned NOT NULL,
  `product_id` int(11) unsigned NOT NULL,
  PRIMARY KEY (`shop_vehicle_product_id`),
  UNIQUE KEY `fk_shop_vehicles_products_vehicle_id` (`vehicle_id`,`product_id`),
  KEY `fk_shop_vehicles_products_product_id` (`product_id`),
  CONSTRAINT `fk_shop_vehicles_products_product_id` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `fk_shop_vehicles_products_vehicle_id` FOREIGN KEY (`vehicle_id`) REFERENCES `shop_vehicles` (`vehicle_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table sites
# ------------------------------------------------------------

DROP TABLE IF EXISTS `sites`;

CREATE TABLE `sites` (
  `site_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `domain_id` int(11) unsigned DEFAULT NULL,
  `name` varchar(255) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `template_id` int(11) unsigned NOT NULL,
  `default_page_id` int(11) unsigned DEFAULT NULL,
  `theme` varchar(255) DEFAULT NULL,
  `font` varchar(255) DEFAULT NULL,
  `colour1` varchar(50) DEFAULT NULL,
  `colour2` varchar(50) DEFAULT NULL,
  `colour3` varchar(50) DEFAULT NULL,
  `colour4` varchar(50) DEFAULT NULL,
  `colour5` varchar(50) DEFAULT NULL,
  `less_css` text,
  `login_page_id` int(11) unsigned DEFAULT NULL,
  `registration_page_id` int(11) unsigned DEFAULT NULL,
  `ga_code` varchar(255) DEFAULT NULL,
  `enable_retina` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `enable_html5` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `show_landing` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `facebook_sdk` tinyint(1) unsigned NOT NULL DEFAULT '0',
  `common_less` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `combine_css` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `loading_overlay` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `fontawesome` tinyint(1) unsigned NOT NULL DEFAULT '1',
  `mail_from` varchar(255) DEFAULT NULL,
  `mail_replyto` varchar(255) DEFAULT NULL,
  `mail_host` varchar(255) NOT NULL DEFAULT 'localhost',
  `mail_port` varchar(5) NOT NULL DEFAULT '587',
  `mail_username` varchar(255) DEFAULT NULL,
  `mail_password` varchar(255) DEFAULT NULL,
  `mail_tls` enum('tls','ssl') NOT NULL DEFAULT 'tls',
  `matomo_site_id` int(11) unsigned DEFAULT NULL,
  `matomo_token_auth` varchar(255) DEFAULT NULL,
  `recaptcha` TINYINT(1) UNSIGNED NOT NULL DEFAULT 0,
  `recaptcha_public_key` VARCHAR(255) NULL,
  `recaptcha_private_key` VARCHAR(255) NULL,
  `recaptcha_threshold` FLOAT UNSIGNED NOT NULL DEFAULT 0.5,
  PRIMARY KEY (`site_id`),
  KEY `fk_sites_template_id` (`template_id`),
  KEY `fk_sites_login_page_id` (`login_page_id`),
  KEY `fk_sites_registration_page_id` (`registration_page_id`),
  KEY `sites_domain_id` (`domain_id`),
  KEY `sites_default_page_id` (`default_page_id`),
  CONSTRAINT `fk_sites_login_page_id` FOREIGN KEY (`login_page_id`) REFERENCES `pages` (`page_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_sites_registration_page_id` FOREIGN KEY (`registration_page_id`) REFERENCES `pages` (`page_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_sites_template_id` FOREIGN KEY (`template_id`) REFERENCES `templates` (`template_id`) ON UPDATE CASCADE,
  CONSTRAINT `sites_default_page_id` FOREIGN KEY (`default_page_id`) REFERENCES `pages` (`page_id`) ON UPDATE CASCADE,
  CONSTRAINT `sites_domain_id` FOREIGN KEY (`domain_id`) REFERENCES `domains` (`domain_id`) ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table tag
# ------------------------------------------------------------

DROP TABLE IF EXISTS `tag`;

CREATE TABLE `tag` (
  `tag_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tag` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`tag_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table tag_document
# ------------------------------------------------------------

DROP TABLE IF EXISTS `tag_document`;

CREATE TABLE `tag_document` (
  `tag_document_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) unsigned DEFAULT NULL,
  `document_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`tag_document_id`),
  KEY `page_id` (`document_id`),
  KEY `tag_page_ibfk_2` (`tag_id`),
  CONSTRAINT `tag_document_ibfk_1` FOREIGN KEY (`document_id`) REFERENCES `document` (`document_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tag_document_ibfk_2` FOREIGN KEY (`tag_id`) REFERENCES `tag` (`tag_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table tag_page
# ------------------------------------------------------------

DROP TABLE IF EXISTS `tag_page`;

CREATE TABLE `tag_page` (
  `tag_page_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `tag_id` int(11) unsigned DEFAULT NULL,
  `page_id` int(11) unsigned DEFAULT NULL,
  PRIMARY KEY (`tag_page_id`),
  KEY `page_id` (`page_id`),
  KEY `tag_page_ibfk_2` (`tag_id`),
  CONSTRAINT `tag_page_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE,
  CONSTRAINT `tag_page_ibfk_2` FOREIGN KEY (`tag_id`) REFERENCES `tag` (`tag_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table templates
# ------------------------------------------------------------

DROP TABLE IF EXISTS `templates`;

CREATE TABLE `templates` (
  `template_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `directory` varchar(255) NOT NULL,
  PRIMARY KEY (`template_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;



# Dump of table users
# ------------------------------------------------------------

DROP TABLE IF EXISTS `users`;

CREATE TABLE `users` (
  `user_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `password_reset` varchar(255) DEFAULT NULL,
  `fname` varchar(255) DEFAULT NULL,
  `lname` varchar(255) DEFAULT NULL,
  `company` varchar(255) DEFAULT NULL,
  `email` varchar(255) NOT NULL,
  `phone` varchar(25) DEFAULT NULL,
  `shipping_address` varchar(25) DEFAULT NULL,
  `shipping_city` varchar(25) DEFAULT NULL,
  `shipping_postalcode` varchar(25) DEFAULT NULL,
  `shipping_province` varchar(25) DEFAULT NULL,
  `shipping_country` varchar(25) DEFAULT NULL,
  `joined` datetime NOT NULL,
  `joined_site_id` int(11) unsigned DEFAULT NULL,
  `last_login` datetime DEFAULT NULL,
  `shopper_group_id` int(11) unsigned DEFAULT NULL,
  `admin` tinyint(1) NOT NULL DEFAULT '0',
  `media_admin` tinyint(1) NOT NULL DEFAULT '0',
  `restricted_admin` tinyint(1) NOT NULL DEFAULT '0',
  `active` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`user_id`),
  UNIQUE KEY `username` (`username`),
  UNIQUE KEY `email` (`email`),
  KEY `fk_users_joined_site_id` (`joined_site_id`),
  KEY `fk_users_shopper_group_id` (`shopper_group_id`),
  CONSTRAINT `fk_users_joined_site_id` FOREIGN KEY (`joined_site_id`) REFERENCES `sites` (`site_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_users_shopper_group_id` FOREIGN KEY (`shopper_group_id`) REFERENCES `shop_shopper_groups` (`shopper_group_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;
/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
