# Logo
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="logo"), `site_id`=1, `tag`="Logo", `position`="header_logo", `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="path", `value`="/images/logo-placeholder.png";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="width", `value`=290;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="text", `value`="{name}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="link", `value`="/";

# Accessibility
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="accessibility"), `site_id`=1, `tag`="Accessibility Controls", `position`="header_right", `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="text_customize", `value`="Customize Font and Colours";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon", `value`="eye";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="language_icon", `value`="fa-language fas";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="text_language", `value`="Translate";

# Main Menu
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="nvmenu"), `site_id`=1, `tag`="Main Menu", `position`="menu", `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="menu_id", `value`=1;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="show_icons", `value`="submenu";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="more_text", `value`="<em class=\"fas fa-bars\" aria-hidden=\"true\"></em> More";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="menu_text", `value`="<em class=\"fas fa-bars\" aria-hidden=\"true\"></em> Menu";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="duplicate_parent_links", `value`=1;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="link_overlay_title", `value`=1;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="search", `value`=1;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="search_action", `value`="/search";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="search_legend", `value`="What are you looking for?";

# Secondary Menu
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="menu"), `site_id`=1, `tag`="Secondary Menu", `position`=null, `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title", `value`="Site Map";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title_heading_level", `value`="h5";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="module_class", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="menu_id", `value`=2;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="style", `value`="vertical";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="hover", `value`=0;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="responsive", `value`=0;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="more_text", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="less_text", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="menu_text", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="mobile_breakpoint", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="duplicate_parent_links", `value`=1;

# Contact Info
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="contact_info"), `site_id`=1, `tag`="Contact Info", `position`=null, `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title", `value`="Contact Us";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title_heading_level", `value`="h5";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="module_class", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="layout", `value`="vertical";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon_size", `value`="1x";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="phone_numbers_icon", `value`="fa-phone fas";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="phone_numbers", `value`="{phone_numbers}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="hours_icon", `value`="fa-clock far";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="hours", `value`="{hours}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="address_icon", `value`="fa-map-marker-alt fas";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="address", `value`="{address}";

# Social Media
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="social"), `site_id`=1, `tag`="Social Media Icons", `position`=null, `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title", `value`="Follow Us";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title_heading_level", `value`="h5";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="module_class", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon_size", `value`="1x";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="facebook", `value`="{facebook}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="twitter", `value`="{twitter}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="gplus", `value`="{gplus}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="flickr", `value`="{flickr}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="pinterest", `value`="{pinterest}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="youtube", `value`="{youtube}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="linkedin", `value`="{linkedin}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="instagram", `value`="{instagram}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="etsy", `value`="{etsy}";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="tumblr", `value`="{tumblr}";

# Slideshow - All module settings will be populated after the user first opens and configures it.
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="slideshow_nivoslider"), `site_id`=1, `tag`="Slideshow", `position`="slideshow", `sort`=1, `published`=0, `always_on`=2;

# 4 Column services module (Featured Services)
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="services"), `site_id`=1, `tag`="Featured Services", `position`=null, `sort`=1, `published`=1, `always_on`=2;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon_size", `value`="1x";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="number_of_services", `value`="4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="column_size", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon1", `value`='diamond';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title1", `value`='Feature 1';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="description1", `value`='Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon2", `value`='diamond';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title2", `value`='Feature 2';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="description2", `value`='Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon3", `value`='diamond';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title3", `value`='Feature 3';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="description3", `value`='Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="icon4", `value`='diamond';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title4", `value`='Feature 4';
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="description4", `value`='Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.';
UPDATE `content_values` SET `value`=CONCAT(`value`, '<div><img class="module_placeholder" id="module_', @module_instance_id, '" src="/placeholder?module_instance_id=', @module_instance_id, '" /></div>') WHERE `page_id`=1 AND `key`="content1";

# Testimonials
SELECT `category_id` FROM `categories` WHERE `site_id`=1 AND `name`="Testimonials" INTO @category_id;
#REPLACE INTO `categories` SET `site_id`=1, `name`="Testimonials", `category_id`=@category_id;
SELECT `content_type_id` FROM `content_types` WHERE `content_type`="Testimonial Snippet" INTO @content_type_id;
INSERT INTO `pages` SET `site_id`=1, `category_id`=@category_id, `content_type_id`=@content_type_id, `created`=NOW(), `title`="Example Company", `title_heading_level`=1, `url`="testimonials/example-company", `description`=null, `content`=null, `rss`=0, `searchable`=1, `allow_url_segments`=0, `allow_url_query`=0, `published`=1;
SELECT MAX(page_id) FROM `pages` INTO @page_id;
INSERT INTO `content_values` SET `page_id`=@page_id, `key`="content", `value`="This is an example testimonial snippet.";
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="content_list"), `site_id`=1, `tag`="Testimonial Snippets", `position`="pagebottom", `sort`=2, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="title_heading_level", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="module_class", `value`="";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="heading_level", `value`="h2";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="category_id", `value`=@category_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="content_type_id", `value`=@content_type_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="num_featured", `value`="0";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="num_articles", `value`="1";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="num_columns", `value`="1";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="num_columns_featured", `value`="1";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="character_limit", `value`="0";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="read_more_text", `value`="Read More <em class=\"fas fa-fw fa-caret-right\" aria-hidden=\"true\"></em>";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="image_alignment", `value`="none";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="image_width", `value`="400";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="image_height", `value`="300";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="image_width_featured", `value`="1200";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="image_height_featured", `value`="400";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="show_title", `value`="no";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="show_date", `value`="0";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="show_text", `value`="1";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="link_first_heading", `value`="0";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="always_show_readmore", `value`="0";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="strip_tags", `value`="no";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="ordering", `value`="newest_created";

# 4 Column Footer
INSERT INTO `module_instances` SET `module_id`=(SELECT `module_id` FROM `modules` WHERE `file_name`="html"), `site_id`=1, `tag`="Footer", `position`="footer", `sort`=1, `published`=1, `always_on`=1;
SELECT MAX(module_instance_id) FROM `module_instances` INTO @module_instance_id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="number_of_columns", `value`="4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_sm1", `value`="1-2";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_md1", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_lg1", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_xl1", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_sm2", `value`="1-2";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_md2", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_lg2", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_xl2", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_sm3", `value`="1-2";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_md3", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_lg3", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_xl3", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_sm4", `value`="1-2";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_md4", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_lg4", `value`="1-4";
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="size_xl4", `value`="1-4";
SELECT `module_instance_id` FROM `module_instances` WHERE `tag`="Secondary Menu" INTO @id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="html1", `value`=CONCAT('<div><img class="module_placeholder" id="module_', @id, '" src="/placeholder?id=', @id, '" /></div>');
SELECT `module_instance_id` FROM `module_instances` WHERE `tag`="Social Media Icons" INTO @id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="html2", `value`=CONCAT('<div><img class="module_placeholder" id="module_', @id, '" src="/placeholder?id=', @id, '" /></div>');
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="html3", `value`=CONCAT('<h5>Location</h5><div>{address}</div>');
SELECT `module_instance_id` FROM `module_instances` WHERE `tag`="Contact Info" INTO @id;
INSERT INTO `module_settings` SET `module_instance_id`=@module_instance_id, `key`="html4", `value`=CONCAT('<div><img class="module_placeholder" id="module_', @id, '" src="/placeholder?id=', @id, '" /></div>');
