<?php
defined('PRODUCT_NAME') or die;
/**
 * This is the base template for NCMS.  DO NOT modify this template.
 * It is completely configurable using the admin user interface.
 * This template REQUIRES the use of a theme.
 */
?>
<html lang="en">
<head>
	<meta charset="utf-8">
	<base href="<?php echo (isset($_SERVER["HTTPS"]) ? "https://" : "http://");?><?php echo $this->input->server("HTTP_HOST");?>/" />
	<title><?php echo ($page->title && $page->title != "Home" ? $page->title . " | " : "");?><?php echo $site->title?></title>

	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/pure-min.css" integrity="sha384-nn4HPE8lTHyVtfCBi5yW9d20FjT8BJwUXyWZT9InLYax14RDjBj46LmSztkmNP9w" crossorigin="anonymous">
	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/grids-responsive-min.css">
	<link rel="shortcut icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<link rel="icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<!--CSS-->

	<?php
	if(file_exists(ABSOLUTE_PATH . "/rss.xml"))
	{
		?><link rel="alternate" type="application/rss+xml" title="<?php echo(COMPANY_NAME);?>" href="/rss.xml" /><?php
	}
	?>

	<meta name="description" content="<?php echo ($page->description ? $page->description : "");?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta property="og:title" content="<?php echo($page->title); ?>" />
    <meta property="og:type" content="<?php echo($page->og_type); ?>" />
    <meta property="og:url" content="<?php echo(base_url($page->url)); ?>" />
    <meta property="og:image" content="<?php echo($page->og_image); ?>" />
    <meta property="og:description" content="<?php echo($page->description); ?>" />
	<!--JS-->
</head>

<body>
	<div id="module_position_content"></div>

	<div class="clear"></div>
	<?php
	// This remains here for compatibility with things like the shop section.
	Mainframe::content();
	?>
	<div class="clear"></div>

	<footer>
		<p class="copyright">Copyright &copy; <?php echo date("Y");?>, <?php echo(COMPANY_NAME);?>, All Rights Reserved</p>
	</footer>
	<script src="/js/min/scripts.min.js"></script>
</body>
</html>
