<?php defined('PRODUCT_NAME') or die; ?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<base href="<?php echo (isset($_SERVER["HTTPS"]) ? "https://" : "http://");?><?php echo $this->input->server("HTTP_HOST");?>/" />
	<title><?php echo ($page->title && $page->title != "Home" ? $page->title . " | " : "");?><?php echo $site->title?></title>

	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/pure-min.css" integrity="sha384-nn4HPE8lTHyVtfCBi5yW9d20FjT8BJwUXyWZT9InLYax14RDjBj46LmSztkmNP9w" crossorigin="anonymous">
	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/grids-responsive-min.css">
	<link rel="stylesheet" href="/templates/<?php echo $template->directory?>/css/contrast.css" />
	<link rel="shortcut icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<link rel="icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<!--CSS-->

	<?php
	if(file_exists(ABSOLUTE_PATH . "/rss.xml"))
	{
		?><link rel="alternate" type="application/rss+xml" title="<?php echo(COMPANY_NAME);?>" href="/rss.xml" /><?php
	}
	?>

	<meta name="description" content="<?php echo ($page->description ? $page->description : "");?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta property="og:title" content="<?php echo($page->title); ?>" />
    <meta property="og:type" content="<?php echo($page->og_type); ?>" />
    <meta property="og:url" content="<?php echo(base_url($page->url)); ?>" />
    <meta property="og:image" content="<?php echo($page->og_image); ?>" />
    <meta property="og:description" content="<?php echo($page->description); ?>" />
	<!--JS-->
</head>

<body>
	<header role="banner"><div id="module_position_header"></div></header>
	<div class="clear"></div>

	<nav role="navigation">
		<div id="module_position_menu"></div>
	</nav>
	<div class="clear"></div>

	<div class="pure-g">
		<?php
		if(Mainframe::countModules($page->page_id, "right"))
		{
			$right = true;
			$class = "pure-u-2-3";
		}
		else
		{
			$right = false;
			$class = "pure-u-1";
		}
		?>
		<div class="<?php echo($class); ?>"><div class="padded"><?php Mainframe::content(); ?></div></div>

		<?php
		if($right)
		{
			?><div class="pure-u-1-3"><div class="padded"><div id="module_position_right"></div></div></div><?php
		}
		?>
	</div>
	<div class="clear"></div>

	<footer role="contentinfo">
		<div id="module_position_footer"></div>
		<div class="clear"></div>

		<p class="copyright">Copyright &copy; <?php echo date("Y");?>, <?php echo(COMPANY_NAME);?>, All Rights Reserved</p>
	</footer>
	<script src="/js/min/scripts.min.js"></script>
</body>
</html>
