<?php defined('PRODUCT_NAME') or die; ?>
<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<base href="<?php echo (isset($_SERVER["HTTPS"]) ? "https://" : "http://");?><?php echo $this->input->server("HTTP_HOST");?>/" />
	<title><?php echo ($page->title && $page->title != "Home" ? $page->title . " | " : "");?><?php echo $site->title?></title>

	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/pure-min.css" integrity="sha384-nn4HPE8lTHyVtfCBi5yW9d20FjT8BJwUXyWZT9InLYax14RDjBj46LmSztkmNP9w" crossorigin="anonymous">
	<link rel="stylesheet" href="https://unpkg.com/purecss@1.0.0/build/grids-responsive-min.css">
	<link rel="stylesheet" href="/templates/<?php echo $template->directory?>/css/contrast.css" />
	<link rel="shortcut icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<link rel="icon" href="/templates/<?php echo $template->directory?>/images/favicon.ico" />
	<!--CSS-->

	<?php
	if(file_exists(ABSOLUTE_PATH . "/rss.xml"))
	{
		?><link rel="alternate" type="application/rss+xml" title="<?php echo(COMPANY_NAME);?>" href="/rss.xml" /><?php
	}
	?>

	<meta name="description" content="<?php echo ($page->description ? $page->description : "");?>" />
	<meta name="viewport" content="width=device-width, initial-scale=1" />
	<meta property="og:title" content="<?php echo($page->title); ?>" />
    <meta property="og:type" content="<?php echo($page->og_type); ?>" />
    <meta property="og:url" content="<?php echo(base_url($page->url)); ?>" />
    <meta property="og:image" content="<?php echo($page->og_image); ?>" />
    <meta property="og:description" content="<?php echo($page->description); ?>" />
	<!--JS-->
</head>

<body>
	<header role="banner" class="padded">
		<div class="pure-g container">
			<div id="logo" class="pure-u-1 pure-u-md-1-4"><div id="module_position_header_logo"></div></div>
			<div id="header-right" class="pure-u-1 pure-u-md-3-4">
				<div id="module_position_header_right"></div>
				<nav role="navigation"><div id="module_position_menu"></div></nav>
			</div>
		</div>
	</header>
	<div class="clear"></div>

	<?php
	if(Mainframe::countModules($page->page_id, "slideshow"))
	{
		?>
		<div id="slideshow" class="pure-g">
			<div class="pure-u-1"><div id="module_position_slideshow"></div></div>
		</div>
		<div class="clear"></div>
		<?php
	}

	if(Mainframe::countModules($page->page_id, "pagetop"))
	{
		?>
		<div id="pagetop" class="pure-g">
			<div class="pure-u-1"><div id="module_position_pagetop"></div></div>
		</div>
		<div class="clear"></div>
		<?php
	}
	?>

	<div id="content" class="pure-g container">
		<div class="pure-u-1"><?php Mainframe::content(); ?></div>
	</div>
	<div class="clear"></div>

	<div id="pagebottom" class="pure-g">
		<div class="pure-u-1"><div id="module_position_pagebottom"></div></div>
	</div>
	<div class="clear"></div>

	<footer role="contentinfo" class="pure-g">
		<div class="pure-u-1 container">
			<div id="module_position_footer"></div>
			<div class="clear"></div>
			<hr />
			<p class="copyright">Copyright &copy; <?php echo date("Y");?>, <?php echo(COMPANY_NAME);?>. All Rights Reserved.</p>
		</div>
	</footer>
	<script src="/js/min/scripts.min.js"></script>
</body>
</html>
