ALTER TABLE `shop_payment_gateways` ADD `configuration` TEXT NULL AFTER `filename`;
ALTER TABLE `shop_shipping_gateways` ADD `configuration` TEXT NULL AFTER `filename`;

CREATE TABLE `shop_routes` (
	  `route_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
	  `site_id` int(11) unsigned NOT NULL,
	  `url` varchar(255) NOT NULL DEFAULT '',
	  `category_path` varchar(255) NOT NULL DEFAULT '',
	  `category_id` int(11) unsigned DEFAULT NULL,
	  `product_id` int(11) unsigned DEFAULT NULL,
	  PRIMARY KEY (`route_id`),
	  UNIQUE KEY `site_id` (`site_id`,`url`),
	  UNIQUE KEY `category_id` (`category_id`),
	  UNIQUE KEY `product_id` (`product_id`),
	  CONSTRAINT `shop_routes_ibfk_3` FOREIGN KEY (`product_id`) REFERENCES `shop_products` (`product_id`) ON DELETE CASCADE ON UPDATE CASCADE,
	  CONSTRAINT `shop_routes_ibfk_1` FOREIGN KEY (`site_id`) REFERENCES `sites` (`id`) ON DELETE CASCADE ON UPDATE CASCADE,
	  CONSTRAINT `shop_routes_ibfk_2` FOREIGN KEY (`category_id`) REFERENCES `shop_categories` (`category_id`) ON DELETE CASCADE ON UPDATE CASCADE
	) ENGINE=InnoDB DEFAULT CHARSET=latin1;
