CREATE TABLE `content_types` (
  `content_type_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `content_type` varchar(255) NOT NULL DEFAULT '',
  `filename` varchar(255) NOT NULL DEFAULT '',
  `sort` int(11) unsigned NOT NULL,
  PRIMARY KEY (`content_type_id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

CREATE TABLE `content_values` (
  `content_value_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `page_id` int(11) unsigned NOT NULL,
  `key` varchar(255) COLLATE utf8_unicode_ci NOT NULL,
  `value` text COLLATE utf8_unicode_ci,
  PRIMARY KEY (`content_value_id`),
  KEY `module_key` (`key`),
  KEY `page_id` (`page_id`),
  CONSTRAINT `content_values_ibfk_1` FOREIGN KEY (`page_id`) REFERENCES `pages` (`page_id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO `content_types` SET `content_type_id`=1, `content_type`='Blank page', `filename`='default', `sort`=1;
INSERT INTO `content_types` SET `content_type_id`=2, `content_type`='Content with image aligned left or right', `filename`='content_image', `sort`=2;
INSERT INTO `content_types` SET `content_type_id`=3, `content_type`='Two columns', `filename`='col2', `sort`=3;
INSERT INTO `content_types` SET `content_type_id`=4, `content_type`='Three columns', `filename`='col3', `sort`=4;
INSERT INTO `content_types` SET `content_type_id`=5, `content_type`='Four columns', `filename`='col4', `sort`=5;
INSERT INTO `content_types` SET `content_type_id`=6, `content_type`='Grid - 2 rows, 2 columns', `filename`='grid2x2', `sort`=6;
INSERT INTO `content_types` SET `content_type_id`=7, `content_type`='Grid - 2 rows, 3 columns', `filename`='grid2x3', `sort`=7;
INSERT INTO `content_types` SET `content_type_id`=8, `content_type`='Grid - 3 rows, 3 columns', `filename`='grid3x3', `sort`=8;
INSERT INTO `content_types` SET `content_type_id`=9, `content_type`='Testimonial', `filename`='testimonial', `sort`=9;
INSERT INTO `content_types` SET `content_type_id`=10, `content_type`='Testimonial Snippet', `filename`='testimonial_snippet', `sort`=10;

ALTER TABLE `pages` ADD `content_type_id` INT(11) UNSIGNED NOT NULL DEFAULT 1 AFTER `category_id`;
ALTER TABLE `pages` ADD CONSTRAINT `content_types_ibfk_1` FOREIGN KEY (`content_type_id`) REFERENCES `content_types` (`content_type_id`) ON DELETE RESTRICT ON UPDATE CASCADE;

INSERT INTO `modules` SET `name`="Content List", `file_name`="content_list", `class_name`="ContentListModule";
ALTER TABLE `menu_items` CHANGE `page_id` `page_id` int(11) unsigned NULL;
ALTER TABLE `pages` ADD `title_heading_level` TINYINT(1) UNSIGNED NOT NULL DEFAULT 1 AFTER `title`;
UPDATE `pages` SET `title_heading_level`=0;
ALTER TABLE `domains` ADD `redirect_url` VARCHAR(255) NULL DEFAULT NULL AFTER `site_id`;
UPDATE `module_settings` SET `key`="size_md1" WHERE `key`="size1";
UPDATE `module_settings` SET `key`="size_md2" WHERE `key`="size2";
UPDATE `module_settings` SET `key`="size_md3" WHERE `key`="size3";
UPDATE `module_settings` SET `key`="size_md4" WHERE `key`="size4";
UPDATE `module_settings` SET `key`="size_md5" WHERE `key`="size5";
UPDATE `module_settings` SET `key`="size_md6" WHERE `key`="size6";
