CREATE TABLE `document` (
  `document_id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `site_id` int(11) unsigned NOT NULL,
  `category_id` int(11) unsigned DEFAULT NULL,
  `title` varchar(255) NOT NULL DEFAULT '',
  `description` text,
  `filename` varchar(255) NOT NULL,
  `created` datetime NOT NULL,
  `created_user_id` int(11) unsigned DEFAULT NULL,
  `modified` datetime DEFAULT NULL,
  `modified_user_id` int(11) unsigned DEFAULT NULL,
  `url` varchar(255) NOT NULL DEFAULT '',
  `access` tinyint(1) unsigned NOT NULL DEFAULT '1' COMMENT '1=public, 2=login, 3=admin',
  `published` tinyint(1) unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`document_id`),
  KEY `created_user_id` (`created_user_id`),
  KEY `modified_user_id` (`modified_user_id`),
  KEY `site_id` (`site_id`),
  KEY `category_id` (`category_id`),
  CONSTRAINT `document_ibfk_1` FOREIGN KEY (`created_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_2` FOREIGN KEY (`modified_user_id`) REFERENCES `users` (`user_id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_3` FOREIGN KEY (`site_id`) REFERENCES `sites` (`site_id`) ON UPDATE CASCADE,
  CONSTRAINT `document_ibfk_4` FOREIGN KEY (`category_id`) REFERENCES `categories` (`category_id`) ON DELETE SET NULL ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
